
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Laura", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hours_worked_by_Peggy")

    # Set the objective function
    model.setObjective(9 * x1 + 6 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14.34 * x1 + 1.9 * x2 >= 47)
    model.addConstr(6.17 * x1 + 4.28 * x2 >= 34)
    model.addConstr(5.43 * x1 + 6.99 * x2 >= 44)
    model.addConstr(2 * x1 - x2 >= 0)
    model.addConstr(14.34 * x1 + 1.9 * x2 <= 73)
    model.addConstr(6.17 * x1 + 4.28 * x2 <= 100)
    model.addConstr(5.43 * x1 + 6.99 * x2 <= 82)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Laura: {x1.varValue}")
        print(f"Hours worked by Peggy: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
