
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of potassium
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # grams of carbohydrates
x2 = m.addVar(vtype=GRB.INTEGER, name="x2") # grams of fiber
x3 = m.addVar(vtype=GRB.INTEGER, name="x3") # milligrams of vitamin D


# Set objective function
m.setObjective(9.98*x0**2 + 7.69*x0*x1 + 5.3*x0*x3 + 3.94*x1*x2 + 4.62*x2**2 + 2.16*x3**2 + 4.23*x1 + 7.64*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x0 + 4*x1 + 10*x2 + 2*x3 <= 132)
m.addConstr(8*x0 + 3*x1 + 4*x2 + 3*x3 <= 142)
m.addConstr(10*x0 + 14*x1 + 6*x2 + 1*x3 <= 47)
m.addConstr(14*x0 + 8*x1 + 10*x2 + 12*x3 <= 124)
m.addConstr(4*x1 + 10*x2 >= 12)
m.addConstr(10*x0 + 4*x1 >= 25)
m.addConstr(3*x1 + 4*x2 >= 21)
m.addConstr(3*x1 + 3*x3 >= 17)
m.addConstr(8*x0 + 4*x2 >= 32)
m.addConstr(8*x0 + 3*x1 + 4*x2 >= 28)
m.addConstr(10*x0 + 6*x2 >= 11)
m.addConstr(10*x0**2 + 14*x1**2 >= 10)
m.addConstr(6*x2 + 1*x3 >= 11)
m.addConstr(14*x1 + 1*x3 >= 11)
m.addConstr(14*x0**2 + 12*x3**2 >= 14)
m.addConstr(10*x2 + 12*x3 >= 20)
m.addConstr(8*x1 + 10*x2 >= 25)
m.addConstr(14*x0**2 + 8*x1**2 >= 31)
m.addConstr(4*x1**2 + 10*x2**2 <= 102)
m.addConstr(10*x2 + 2*x3 <= 49)
m.addConstr(10*x0**2 + 2*x3**2 <= 87)
m.addConstr(10*x0 + 10*x2 <= 120)
m.addConstr(4*x1 + 2*x3 <= 35)
m.addConstr(10*x0**2 + 4*x1**2 <= 62)
m.addConstr(10*x0**2 + 4*x1**2 + 2*x3**2 <= 110)
m.addConstr(4*x1**2 + 10*x2**2 + 2*x3**2 <= 33)
m.addConstr(10*x0**2 + 4*x1**2 + 10*x2**2 <= 46)
m.addConstr(10*x0 + 4*x1 + 10*x2 + 2*x3 <= 46)
m.addConstr(3*x1 + 4*x2 <= 38)
m.addConstr(4*x2**2 + 3*x3**2 <= 120)
m.addConstr(3*x1 + 3*x3 <= 66)
m.addConstr(8*x0 + 4*x2 <= 106)
m.addConstr(8*x0 + 3*x1 + 4*x2 + 3*x3 <= 106)
m.addConstr(14*x1**2 + 1*x3**2 <= 36)
m.addConstr(10*x0 + 1*x3 <= 26)
m.addConstr(14*x1 + 6*x2 + 1*x3 <= 26)
m.addConstr(10*x0 + 14*x1 + 6*x2 + 1*x3 <= 26)
m.addConstr(8*x1**2 + 10*x2**2 <= 36)
m.addConstr(14*x0**2 + 12*x3**2 <= 108)
m.addConstr(14*x0 + 8*x1 + 10*x2 + 12*x3 <= 108)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

