
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER)  # milligrams of potassium
x1 = m.addVar(name="x1")  # grams of carbohydrates
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # grams of fiber
x3 = m.addVar(name="x3", vtype=gp.GRB.INTEGER)  # milligrams of vitamin D

# Objective function
m.setObjective(9.98 * x0**2 + 7.69 * x0 * x1 + 5.3 * x0 * x3 + 3.94 * x1 * x2 + 4.62 * x2**2 + 2.16 * x3**2 + 4.23 * x1 + 7.64 * x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(10 * x0 <= 132)
m.addConstr(8 * x0 <= 142)
m.addConstr(10 * x0 <= 47)
m.addConstr(14 * x0 <= 124)
m.addConstr(4 * x1 <= 132)
m.addConstr(3 * x1 <= 142)
m.addConstr(14 * x1 <= 47)
m.addConstr(8 * x1 <= 124)
m.addConstr(10 * x2 <= 132)
m.addConstr(4 * x2 <= 142)
m.addConstr(6 * x2 <= 47)
m.addConstr(10 * x2 <= 124)
m.addConstr(2 * x3 <= 132)
m.addConstr(3 * x3 <= 142)
m.addConstr(x3 <= 47)
m.addConstr(12 * x3 <= 124)
m.addConstr(4 * x1 + 10 * x2 >= 12)
m.addConstr(10 * x0 + 4 * x1 >= 25)
m.addConstr(3 * x1 + 4 * x2 >= 21)
m.addConstr(3 * x1 + 3 * x3 >= 17)
m.addConstr(8 * x0 + 4 * x2 >= 32)
m.addConstr(8 * x0 + 3 * x1 + 4 * x2 >= 28)
m.addConstr(10 * x0 + 6 * x2 >= 11)
m.addConstr(100 * x0**2 + 196 * x1**2 >= 10)
m.addConstr(6 * x2 + x3 >= 11)
m.addConstr(14 * x1 + x3 >= 11)
m.addConstr(196 * x0**2 + 144 * x3**2 >= 14)
m.addConstr(10 * x2 + x3 >= 20)
m.addConstr(8 * x1 + 10 * x2 >= 25)
m.addConstr(196 * x0**2 + 196 * x1**2 >= 31)
m.addConstr(16 * x1**2 + 100 * x2**2 <= 102)
m.addConstr(10 * x2 + 2 * x3 <= 49)
m.addConstr(100 * x0**2 + 144 * x3**2 <= 87)
m.addConstr(10 * x0 + 10 * x2 <= 120)
m.addConstr(4 * x1 + 2 * x3 <= 35)
m.addConstr(100 * x0**2 + 196 * x1**2 <= 62)
m.addConstr(100 * x0**2 + 196 * x1**2 + 144 * x3**2 <= 110)
m.addConstr(16 * x1**2 + 100 * x2**2 + 144 * x3**2 <= 33)
m.addConstr(100 * x0**2 + 196 * x1**2 + 100 * x2**2 <= 46)
m.addConstr(10 * x0 + 4 * x1 + 10 * x2 + 2 * x3 <= 46)
m.addConstr(3 * x1 + 4 * x2 <= 38)
m.addConstr(16 * x2**2 + 144 * x3**2 <= 120)
m.addConstr(3 * x1 + 3 * x3 <= 66)
m.addConstr(8 * x0 + 4 * x2 <= 106)
m.addConstr(8 * x0 + 3 * x1 + 4 * x2 + 3 * x3 <= 106)
m.addConstr(196 * x1**2 + 144 * x3**2 <= 36)
m.addConstr(10 * x0 + x3 <= 26)
m.addConstr(14 * x1 + 6 * x2 + x3 <= 26)
m.addConstr(8 * x0 + 3 * x1 + 4 * x2 + 3 * x3 <= 26)
m.addConstr(16 * x1**2 + 100 * x2**2 <= 36)
m.addConstr(196 * x0**2 + 144 * x3**2 <= 108)
m.addConstr(8 * x0 + 3 * x1 + 10 * x2 + 3 * x3 <= 108)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("milligrams of potassium:", x0.varValue)
    print("grams of carbohydrates:", x1.varValue)
    print("grams of fiber:", x2.varValue)
    print("milligrams of vitamin D:", x3.varValue)
else:
    print("No optimal solution found.")
