
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    oranges = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oranges")
    bagged_salads = m.addVar(lb=0, vtype=GRB.INTEGER, name="bagged_salads")


    # Set objective function
    m.setObjective(3.92 * oranges + 5.07 * bagged_salads, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1 * oranges + 2 * bagged_salads >= 13, "iron_min")
    m.addConstr(4 * oranges + 5 * bagged_salads >= 6, "fat_min")
    m.addConstr(5 * oranges + 3 * bagged_salads >= 8, "protein_min")
    m.addConstr(-1 * oranges + 10 * bagged_salads >= 0, "orange_salad_relation")
    m.addConstr(1 * oranges + 2 * bagged_salads <= 22, "iron_max")
    m.addConstr(4 * oranges + 5 * bagged_salads <= 16, "fat_max")
    m.addConstr(5 * oranges + 3 * bagged_salads <= 11, "protein_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("oranges:", oranges.x)
        print("bagged_salads:", bagged_salads.x)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
