
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    oranges = model.addVar(name="oranges", lb=0, ub=None)
    bagged_salads = model.addVar(name="bagged_salads", lb=0, ub=None, integrality=1)

    # Define the objective function
    model.setObjective(3.92 * oranges + 5.07 * bagged_salads, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(oranges + 2 * bagged_salads >= 13, name="iron_constraint")
    model.addConstr(4 * oranges + 5 * bagged_salads >= 6, name="fat_constraint1")
    model.addConstr(5 * oranges + 3 * bagged_salads >= 8, name="protein_constraint1")
    model.addConstr(-oranges + 10 * bagged_salads >= 0, name="linear_constraint")
    model.addConstr(oranges + 2 * bagged_salads <= 22, name="iron_constraint2")
    model.addConstr(4 * oranges + 5 * bagged_salads <= 16, name="fat_constraint2")
    model.addConstr(5 * oranges + 3 * bagged_salads <= 11, name="protein_constraint2")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Oranges: {oranges.varValue}")
        print(f"Bagged Salads: {bagged_salads.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
