
from gurobipy import Model, GRB

# Create a new model
model = Model("Nutrition Optimization")

# Create variables
carbohydrates = model.addVar(vtype=GRB.CONTINUOUS, name="carbohydrates")
fat = model.addVar(vtype=GRB.CONTINUOUS, name="fat")
iron = model.addVar(vtype=GRB.CONTINUOUS, name="iron")
vitamin_b5 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b5")
protein = model.addVar(vtype=GRB.CONTINUOUS, name="protein")
vitamin_b9 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b9")


# Set objective function
model.setObjective(7*carbohydrates + 3*fat + 1*iron + 5*vitamin_b5 + 2*protein + 5*vitamin_b9, GRB.MINIMIZE)

# Add constraints
model.addConstr(8*iron + 8*protein >= 24)
model.addConstr(8*protein + 7*vitamin_b9 >= 19)
model.addConstr(6*vitamin_b5 + 8*protein >= 26)
model.addConstr(1*fat + 6*iron >= 16)
model.addConstr(1*fat + 7*vitamin_b9 >= 24)
model.addConstr(6*vitamin_b5 + 7*vitamin_b9 >= 36)
model.addConstr(6*iron + 6*vitamin_b5 + 8*protein >= 27)
model.addConstr(1*fat + 6*vitamin_b5 + 8*protein >= 27)
model.addConstr(8*carbohydrates + 1*fat + 6*iron >= 27)
model.addConstr(6*iron + 6*vitamin_b5 + 8*protein >= 26)
model.addConstr(1*fat + 6*vitamin_b5 + 8*protein >= 26)
model.addConstr(8*carbohydrates + 1*fat + 6*iron >= 26)
model.addConstr(6*iron + 6*vitamin_b5 + 8*protein >= 23)
model.addConstr(1*fat + 6*vitamin_b5 + 8*protein >= 23)
model.addConstr(8*carbohydrates + 1*fat + 6*iron >= 23)
model.addConstr(8*carbohydrates + 1*fat + 6*iron + 6*vitamin_b5 + 8*protein + 7*vitamin_b9 >= 23)
model.addConstr(4*carbohydrates + 2*vitamin_b5 >= 15)
model.addConstr(8*iron + 2*vitamin_b5 >= 13)
model.addConstr(4*carbohydrates + 7*vitamin_b9 >= 16)
model.addConstr(2*vitamin_b5 + 4*protein >= 11)
model.addConstr(4*fat + 8*iron >= 7)
model.addConstr(4*carbohydrates + 4*fat >= 12)
model.addConstr(4*fat + 4*protein >= 7)
model.addConstr(4*protein + 7*vitamin_b9 >= 10)
model.addConstr(8*iron + 4*protein >= 16)
model.addConstr(4*carbohydrates + 8*iron >= 14)
model.addConstr(4*carbohydrates + 2*vitamin_b5 + 7*vitamin_b9 >= 12)
model.addConstr(4*carbohydrates + 4*protein + 7*vitamin_b9 >= 12)
model.addConstr(4*carbohydrates + 2*vitamin_b5 + 7*vitamin_b9 >= 15)
model.addConstr(4*carbohydrates + 4*protein + 7*vitamin_b9 >= 15)
model.addConstr(4*carbohydrates + 4*fat + 8*iron + 2*vitamin_b5 + 4*protein + 7*vitamin_b9 >= 15)
model.addConstr(-5*iron + 3*vitamin_b5 >= 0)
model.addConstr(8*fat - 6*iron >= 0)
model.addConstr(1*fat + 8*protein <= 228)
model.addConstr(8*carbohydrates + 7*vitamin_b9 <= 178)
model.addConstr(1*fat + 6*iron <= 176)
model.addConstr(1*fat + 7*vitamin_b9 <= 133)
model.addConstr(8*carbohydrates + 6*iron + 8*protein <= 59)
model.addConstr(8*carbohydrates + 6*vitamin_b5 + 7*vitamin_b9 <= 165)
model.addConstr(6*vitamin_b5 + 8*protein + 7*vitamin_b9 <= 163)
model.addConstr(8*carbohydrates + 6*iron + 6*vitamin_b5 <= 216)
model.addConstr(1*fat + 6*iron + 7*vitamin_b9 <= 180)
model.addConstr(8*carbohydrates + 1*fat + 7*vitamin_b9 <= 45)
model.addConstr(1*fat + 6*vitamin_b5 + 7*vitamin_b9 <= 89)
model.addConstr(1*fat + 6*iron + 8*protein <= 173)
model.addConstr(6*iron + 6*vitamin_b5 + 7*vitamin_b9 <= 105)
model.addConstr(4*fat + 2*vitamin_b5 <= 48)
model.addConstr(8*iron + 2*vitamin_b5 <= 72)
model.addConstr(4*fat + 8*iron <= 16)
model.addConstr(8*iron + 4*protein + 7*vitamin_b9 <= 86)
model.addConstr(4*carbohydrates + 4*fat + 8*iron <= 82)
model.addConstr(8*iron + 2*vitamin_b5 + 7*vitamin_b9 <= 76)
model.addConstr(2*vitamin_b5 + 4*protein + 7*vitamin_b9 <= 19)



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {model.status}")

