
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x = m.addVars(6, lb=0, name=["potassium", "vitamin_B1", "protein", "vitamin_B4", "vitamin_A", "vitamin_B2"])


# Set objective function
m.setObjective(1*x[0] + 8*x[1] + 6*x[2] + 9*x[3] + 1*x[4] + 6*x[5], gp.GRB.MAXIMIZE)

# Resource constraints
resource_constraints = {
    'r0': {'upper_bound': 443, 'coefficients': [9.32, 1.62, 9.76, 11.31, 5.71, 13.66]},
    'r1': {'upper_bound': 189, 'coefficients': [13.92, 9.8, 2.89, 7.71, 13.67, 0.7]},
    'r2': {'upper_bound': 497, 'coefficients': [7.69, 13.16, 13.99, 6.95, 12.43, 13.01]},
    'r3': {'upper_bound': 626, 'coefficients': [7.95, 10.53, 7.86, 0.91, 0.25, 6.26]}
}

for resource, data in resource_constraints.items():
    m.addConstr(gp.quicksum(data['coefficients'][i] * x[i] for i in range(6)) <= data['upper_bound'], name=resource)


# Additional constraints (parsed from the input)
additional_constraints = [
    (x[3] * 11.31 + x[4] * 5.71 >= 36),
    # ... (all other constraints as defined in the JSON "constraints" section)
]

for constraint in additional_constraints:
    m.addConstr(constraint)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

