
import gurobipy as gp

# Create a new model
m = gp.Model("calcium_optimization")

# Create variables
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")


# Set objective function
m.setObjective(8*oranges + 6*bananas + 5*peanutbutter_sandwiches + 3*pickles + 6*cornichons, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*peanutbutter_sandwiches + 14*cornichons >= 17)
m.addConstr(11*oranges + 14*cornichons >= 16)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches >= 18)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles >= 30)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles + 14*cornichons >= 24)
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 24)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 14*cornichons >= 24)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 17*pickles >= 24)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles + 14*cornichons >= 27)
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 27)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 14*cornichons >= 27)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 17*pickles >= 27)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles + 14*cornichons >= 35)
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 35)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 14*cornichons >= 35)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 17*pickles >= 35)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles + 14*cornichons >= 27)
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 27)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 14*cornichons >= 27)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 17*pickles >= 27)
m.addConstr(11*oranges + 14*cornichons <= 55)
m.addConstr(2*peanutbutter_sandwiches + 14*cornichons <= 158)
m.addConstr(11*oranges + 17*pickles <= 154)
m.addConstr(17*pickles + 14*cornichons <= 122)
m.addConstr(11*oranges + 2*peanutbutter_sandwiches <= 204)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles <= 119)
m.addConstr(11*oranges + 2*peanutbutter_sandwiches + 17*pickles <= 85)
m.addConstr(11*oranges + 9*bananas + 2*peanutbutter_sandwiches + 17*pickles + 14*cornichons <= 85)
m.addConstr(11*oranges + 9*bananas + 2*peanutbutter_sandwiches + 17*pickles + 14*cornichons <= 215)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

