
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
oranges = m.addVar(name='oranges', lb=0)
bananas = m.addVar(name='bananas', lb=0)
peanutbutter_sandwiches = m.addVar(name='peanutbutter_sandwiches', lb=0)
pickles = m.addVar(name='pickles', lb=0)
cornichons = m.addVar(name='cornichons', lb=0)

# Objective function
m.setObjective(8*oranges + 6*bananas + 5*peanutbutter_sandwiches + 3*pickles + 6*cornichons, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(2*peanutbutter_sandwiches + 14*cornichons >= 17)
m.addConstr(11*oranges + 14*cornichons >= 16)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches >= 18)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles >= 30)
m.addConstr(peanutbutter_sandwiches + 17*pickles + 14*cornichons >= 24)
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 24)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 14*cornichons >= 24)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 17*pickles >= 24)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles + 14*cornichons >= 27)
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 27)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 14*cornichons >= 27)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 17*pickles >= 27)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles + 14*cornichons >= 35)
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 35)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 14*cornichons >= 35)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 17*pickles >= 35)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles + 14*cornichons >= 27)
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 27)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 14*cornichons >= 27)
m.addConstr(9*bananas + 2*peanutbutter_sandwiches + 17*pickles >= 27)
m.addConstr(11*oranges + 14*cornichons <= 55)
m.addConstr(2*peanutbutter_sandwiches + 14*cornichons <= 158)
m.addConstr(11*oranges + 17*pickles <= 154)
m.addConstr(17*pickles + 14*cornichons <= 122)
m.addConstr(11*oranges + 2*peanutbutter_sandwiches <= 204)
m.addConstr(2*peanutbutter_sandwiches + 17*pickles <= 119)
m.addConstr(11*oranges + 2*peanutbutter_sandwiches + 17*pickles <= 85)
m.addConstr(11*oranges + 9*bananas + 2*peanutbutter_sandwiches + 17*pickles + 14*cornichons <= 85)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Oranges: ', oranges.varValue)
    print('Bananas: ', bananas.varValue)
    print('Peanutbutter sandwiches: ', peanutbutter_sandwiches.varValue)
    print('Pickles: ', pickles.varValue)
    print('Cornichons: ', cornichons.varValue)
else:
    print('The model is infeasible')
