
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', lb=0)  # hours worked by Hank
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Paul
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Mary

    # Define the objective function
    model.setObjective(2*x0 + 7*x1 + 7*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(16*x0 <= 169)
    model.addConstr(11*x0 <= 316)
    model.addConstr(7*x0 <= 223)
    model.addConstr(15*x0 <= 263)
    model.addConstr(2*x0 <= 131)
    model.addConstr(16*x1 <= 169)
    model.addConstr(17*x1 <= 316)
    model.addConstr(21*x1 <= 223)
    model.addConstr(5*x1 <= 263)
    model.addConstr(4*x1 <= 131)
    model.addConstr(3*x2 <= 169)
    model.addConstr(2*x2 <= 316)
    model.addConstr(13*x2 <= 223)
    model.addConstr(7*x2 <= 263)
    model.addConstr(7*x2 <= 131)
    model.addConstr(16*x0 + 3*x2 >= 41)
    model.addConstr(21*x1 + 13*x2 >= 33)
    model.addConstr(7*x0 + 13*x2 >= 29)
    model.addConstr(7*x0 + 21*x1 + 13*x2 >= 73)
    model.addConstr(15*x0 + 7*x2 >= 84)
    model.addConstr(15*x0 + 5*x1 >= 83)
    model.addConstr(5*x1 + 7*x2 >= 64)
    model.addConstr(2*x0 + 7*x2 >= 15)
    model.addConstr(4*x1 + 7*x2 >= 22)
    model.addConstr(2*x0 + 4*x1 + 7*x2 >= 29)
    model.addConstr(16*x0 + 16*x1 <= 72)
    model.addConstr(16*x0 + 3*x2 <= 152)
    model.addConstr(16*x1 + 3*x2 <= 110)
    model.addConstr(16*x0 + 16*x1 + 3*x2 <= 110)
    model.addConstr(17*x1 + 2*x2 <= 106)
    model.addConstr(11*x0 + 17*x1 + 2*x2 <= 106)
    model.addConstr(7*x0 + 21*x1 <= 211)
    model.addConstr(21*x1 + 13*x2 <= 159)
    model.addConstr(7*x0 + 21*x1 + 13*x2 <= 159)
    model.addConstr(5*x1 + 7*x2 <= 210)
    model.addConstr(15*x0 + 5*x1 <= 202)
    model.addConstr(15*x0 + 5*x1 + 7*x2 <= 202)
    model.addConstr(4*x1 + 7*x2 <= 107)
    model.addConstr(2*x0 + 4*x1 + 7*x2 <= 107)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Hours worked by Hank: ', x0.varValue)
        print('Hours worked by Paul: ', x1.varValue)
        print('Hours worked by Mary: ', x2.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
