
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("minimize_work_hours")

    # Create variables
    dale_hours = model.addVar(lb=0, name="dale_hours")  # Non-negative hours
    peggy_hours = model.addVar(lb=0, name="peggy_hours") # Non-negative hours


    # Set objective function
    model.setObjective(6.93 * dale_hours + 5.9 * peggy_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8 * dale_hours + 8 * peggy_hours >= 44, "c1: likelihood_to_quit_min")
    model.addConstr(1 * dale_hours + 3 * peggy_hours >= 101, "c2: organization_score_min")
    model.addConstr(12 * dale_hours + 13 * peggy_hours >= 86, "c3: productivity_rating_min")
    model.addConstr(4 * dale_hours - 8 * peggy_hours >= 0, "c4: dale_peggy_relation")
    model.addConstr(8 * dale_hours + 8 * peggy_hours <= 62, "c5: likelihood_to_quit_max")
    model.addConstr(1 * dale_hours + 3 * peggy_hours <= 233, "c6: organization_score_max")
    model.addConstr(12 * dale_hours + 13 * peggy_hours <= 132, "c7: productivity_rating_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    # Print solution if feasible
    elif model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Dale Hours: %g' % dale_hours.x)
        print('Peggy Hours: %g' % peggy_hours.x)
    else:
        print(f"Optimization terminated with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
