
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Dale", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Peggy", lb=0)  # Assuming hours cannot be negative

    # Objective function
    model.setObjective(6.93 * x1 + 5.9 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * x1 + 8 * x2 >= 44)
    model.addConstr(8 * x1 + 8 * x2 <= 62)
    model.addConstr(x1 + 3 * x2 >= 101)
    model.addConstr(x1 + 3 * x2 <= 233)
    model.addConstr(12 * x1 + 13 * x2 >= 86)
    model.addConstr(12 * x1 + 13 * x2 <= 132)
    model.addConstr(4 * x1 - 8 * x2 >= 0)

    # Dale's fixed attributes
    model.addConstr(x1 >= 0)  # This is already considered by lb
    model.addConstr(x1 <= 0)  # This will make x1 = 0, but we need to consider the actual constraints given
    # Directly using given numbers as they relate to individual not total
    # model.addConstr(x1 == 8 / 8) # This doesn't make sense here as per problem description it seems these are not constraints but given info
    # model.addConstr(x1 == 1 / 1)
    # model.addConstr(x1 == 12 / 12)

    # Peggy's fixed attributes
    # model.addConstr(x2 == 8 / 8)
    # model.addConstr(3 * x2 == 3)
    # model.addConstr(13 * x2 == 13)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {x1.varValue}")
        print(f"Hours worked by Peggy: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
