
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bacon = m.addVar(vtype=gp.GRB.INTEGER, name="bacon")
pizza = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pizza")
salad = m.addVar(vtype=gp.GRB.CONTINUOUS, name="salad")


# Set objective function
m.setObjective(8.71*bacon**2 + 3.39*bacon*salad + 3.22*pizza*salad + 2.28*salad**2 + 7.59*pizza + 6.1*salad, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(22*bacon**2 + 13*pizza**2 >= 45)
m.addConstr(13*pizza**2 + 22*salad**2 >= 52)
m.addConstr(22*bacon + 13*pizza + 22*salad >= 52)
m.addConstr(2*pizza + 7*salad >= 38)
m.addConstr(8*bacon + 2*pizza >= 22)
m.addConstr(8*bacon + 2*pizza + 7*salad >= 41)
m.addConstr(20*bacon**2 + 2*salad**2 >= 106)
m.addConstr(3*pizza**2 + 2*salad**2 >= 113)
m.addConstr(20*bacon**2 + 3*pizza**2 >= 138)
m.addConstr(20*bacon**2 + 3*pizza**2 + 2*salad**2 >= 122)
m.addConstr(20*bacon + 3*pizza + 2*salad >= 122)
m.addConstr(19*pizza + 13*salad >= 84)
m.addConstr(17*bacon + 13*salad >= 101)
m.addConstr(17*bacon**2 + 19*pizza**2 >= 95)
m.addConstr(17*bacon + 19*pizza + 13*salad >= 95)
m.addConstr(bacon + 23*pizza >= 57)
m.addConstr(bacon + 11*salad >= 44)
m.addConstr(bacon + 23*pizza + 11*salad >= 44)
m.addConstr(-10*bacon + 9*salad >= 0)
m.addConstr(-4*pizza**2 + 5*salad**2 >= 0)
m.addConstr(3*pizza**2 + 2*salad**2 <= 291)
m.addConstr(20*bacon + 2*salad <= 218)
m.addConstr(17*bacon**2 + 13*salad**2 <= 279)
m.addConstr(bacon + 23*pizza + 11*salad <= 140)

m.addConstr(22*bacon + 13*pizza + 22*salad <= 235) #r0
m.addConstr(8*bacon + 2*pizza + 7*salad <= 199) #r1
m.addConstr(20*bacon + 3*pizza + 2*salad <= 468) #r2
m.addConstr(17*bacon + 19*pizza + 13*salad <= 376) #r3
m.addConstr(bacon + 23*pizza + 11*salad <= 199) #r4


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bacon:', bacon.x)
    print('pizza:', pizza.x)
    print('salad:', salad.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

