
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="strips_of_bacon", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="slices_of_pizza")
x2 = m.addVar(name="fruit_salads")

# Objective function
m.setObjective(8.71 * x0**2 + 3.39 * x0 * x2 + 3.22 * x1 * x2 + 2.28 * x2**2 + 7.59 * x1 + 6.1 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(22 * x0 <= 235)
m.addConstr(8 * x0 <= 199)
m.addConstr(20 * x0 <= 468)
m.addConstr(17 * x0 <= 376)
m.addConstr(x0 <= 199)
m.addConstr(13 * x1 <= 235)
m.addConstr(2 * x1 <= 199)
m.addConstr(3 * x1 <= 468)
m.addConstr(19 * x1 <= 376)
m.addConstr(23 * x1 <= 199)
m.addConstr(22 * x2 <= 235)
m.addConstr(7 * x2 <= 199)
m.addConstr(2 * x2 <= 468)
m.addConstr(13 * x2 <= 376)
m.addConstr(11 * x2 <= 199)
m.addConstr(22 * x0 + 13 * x1 >= 45)
m.addConstr(13 * x1 + 22 * x2 >= 52)
m.addConstr(22 * x0 + 13 * x1 + 22 * x2 >= 52)
m.addConstr(2 * x1 + 7 * x2 >= 38)
m.addConstr(8 * x0 + 2 * x1 >= 22)
m.addConstr(8 * x0 + 2 * x1 + 7 * x2 >= 41)
m.addConstr(20 * x0 + 2 * x2 >= 106)
m.addConstr(3 * x1 + 2 * x2 >= 113)
m.addConstr(20 * x0 + 3 * x1 >= 138)
m.addConstr(20 * x0 + 3 * x1 + 2 * x2 >= 122)
m.addConstr(19 * x1 + 13 * x2 >= 84)
m.addConstr(17 * x0 + 13 * x2 >= 101)
m.addConstr(17**2 * x0**2 + 19**2 * x1**2 >= 95)
m.addConstr(17 * x0 + 19 * x1 + 13 * x2 >= 95)
m.addConstr(x0 + 23 * x1 >= 57)
m.addConstr(x0 + 11 * x2 >= 44)
m.addConstr(x0 + 23 * x1 + 11 * x2 >= 44)
m.addConstr(-10 * x0 + 9 * x2 >= 0)
m.addConstr(-4 * x1**2 + 5 * x2**2 >= 0)
m.addConstr(3 * x1**2 + 2 * x2**2 <= 291)
m.addConstr(20 * x0 + 2 * x2 <= 218)
m.addConstr(17**2 * x0**2 + 13**2 * x2**2 <= 279)
m.addConstr(x0 + 23 * x1 + 11 * x2 <= 140)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Strips of bacon: ", x0.varValue)
    print("Slices of pizza: ", x1.varValue)
    print("Fruit salads: ", x2.varValue)
else:
    print("The model is infeasible")
