
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")
    x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B6")


    # Set objective function
    m.setObjective(6.63*x0**2 + 7.63*x0*x1 + 4.72*x1**2 + 3.6*x0 + 8.16*x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1*x0 + 6*x1 <= 78, "c0")
    m.addConstr(2*x0 + 1*x1 <= 77, "c1")
    m.addConstr(x0**2 + x1**2 >= 32, "c2")
    m.addConstr(2*x0**2 + x1**2 >= 33, "c3")
    m.addConstr(2*x0**2 + x1**2 <= 54, "c4")
    m.addConstr(8*x0 - 7*x1 >= 0, "c5")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('grams_of_carbohydrates:', x0.x)
        print('milligrams_of_vitamin_B6:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
