
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")
x2 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B6")

# Set the objective function
m.setObjective(6.63*x1**2 + 7.63*x1*x2 + 4.72*x2**2 + 3.6*x1 + 8.16*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1**2 + 36*x2**2 >= 32, "cognitive_performance_index")
m.addConstr(4*x1**2 + x2**2 >= 33, "kidney_support_index_squared")
m.addConstr(8*x1 - 7*x2 >= 0, "carbohydrates_vitamin_b6_ratio")
m.addConstr(x1 + 6*x2 <= 78, "total_cognitive_performance")
m.addConstr(2*x1 + x2 <= 54, "total_kidney_support")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of carbohydrates: {x1.x}")
    print(f"Milligrams of vitamin B6: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
