
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x1 = m.addVar(name="carbohydrates", vtype=gurobi.GRB.CONTINUOUS)
x2 = m.addVar(name="vitamin_B6", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(6.63*x1**2 + 7.63*x1*x2 + 4.72*x2**2 + 3.6*x1 + 8.16*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1**2 + 36*x2**2 >= 32, name="cognitive_performance_squared")
m.addConstr(4*x1**2 + x2**2 >= 33, name="kidney_support_squared")
m.addConstr(8*x1 - 7*x2 >= 0, name="carbohydrates_vitamin_B6_relation")
m.addConstr(x1 + 6*x2 <= 78, name="total_cognitive_performance")
m.addConstr(2*x1 + x2 <= 54, name="total_kidney_support")
m.addConstr(x1 <= 90, name="carbohydrates_cognitive_performance_limit")
m.addConstr(2*x1 <= 77, name="carbohydrates_kidney_support_limit")

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Carbohydrates: {x1.varValue}")
    print(f"Vitamin B6: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
