
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x3")


# Set objective function
m.setObjective(2*x0 + 5*x1 + 7*x2 + 7*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(7*x1 + 1*x2 >= 17)
m.addConstr(7*x1 + 12*x3 >= 23)
m.addConstr(1*x2 + 12*x3 >= 18)
m.addConstr(3*x0 + 7*x1 + 1*x2 + 12*x3 >= 18)
m.addConstr(4*x0 + 9*x2 >= 48)
m.addConstr(4*x0 + 12*x1 >= 22)
m.addConstr(4*x0 + 7*x3 >= 37)
m.addConstr(4*x0 + 12*x1 + 7*x3 >= 46)
m.addConstr(12*x1 + 9*x2 + 7*x3 >= 46)
m.addConstr(4*x0 + 9*x2 + 7*x3 >= 46)
m.addConstr(4*x0 + 12*x1 + 9*x2 >= 46)
m.addConstr(4*x0 + 12*x1 + 7*x3 >= 50)
m.addConstr(12*x1 + 9*x2 + 7*x3 >= 50)
m.addConstr(4*x0 + 9*x2 + 7*x3 >= 50)
m.addConstr(4*x0 + 12*x1 + 9*x2 >= 50)
m.addConstr(4*x0 + 12*x1 + 7*x3 >= 53)
m.addConstr(12*x1 + 9*x2 + 7*x3 >= 53)
m.addConstr(4*x0 + 9*x2 + 7*x3 >= 53)
m.addConstr(4*x0 + 12*x1 + 9*x2 >= 53)
m.addConstr(4*x0 + 12*x1 + 7*x3 >= 51)
m.addConstr(12*x1 + 9*x2 + 7*x3 >= 51)
m.addConstr(4*x0 + 9*x2 + 7*x3 >= 51)
m.addConstr(4*x0 + 12*x1 + 9*x2 >= 51)
m.addConstr(4*x0 + 12*x1 + 9*x2 + 7*x3 >= 51)
m.addConstr(4*x0 + 4*x3 >= 24)
m.addConstr(12*x1 + 5*x2 >= 10)
m.addConstr(4*x0 + 12*x1 >= 16)
m.addConstr(4*x0 + 12*x1 + 5*x2 + 4*x3 >= 16)
m.addConstr(1*x1 + 6*x2 >= 29)
m.addConstr(9*x0 + 2*x3 >= 24)
m.addConstr(1*x1 + 2*x3 >= 25)
m.addConstr(9*x0 + 6*x2 >= 18)
m.addConstr(9*x0 + 1*x1 + 6*x2 + 2*x3 >= 18)
m.addConstr(-1*x1 + 1*x2 >= 0)
m.addConstr(3*x0 + 7*x1 <= 67)
m.addConstr(3*x0 + 7*x1 + 12*x3 <= 39)
m.addConstr(3*x0 + 1*x2 + 12*x3 <= 77)
m.addConstr(7*x1 + 1*x2 + 12*x3 <= 87)
m.addConstr(12*x1 + 9*x2 + 7*x3 <= 152)
m.addConstr(4*x0 + 5*x2 <= 99)
m.addConstr(12*x1 + 4*x3 <= 25)
m.addConstr(5*x2 + 4*x3 <= 62)
m.addConstr(4*x0 + 12*x1 <= 41)
m.addConstr(12*x1 + 5*x2 + 4*x3 <= 59)
m.addConstr(4*x0 + 12*x1 + 4*x3 <= 87)
m.addConstr(9*x0 + 2*x3 <= 117)
m.addConstr(1*x1 + 6*x2 + 2*x3 <= 137)
m.addConstr(9*x0 + 1*x1 + 2*x3 <= 140)



# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

