
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by George
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Paul
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Ringo
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Mary

    # Objective function
    model.setObjective(2 * x0 + 5 * x1 + 7 * x2 + 7 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7 * x1 + x2 >= 17)
    model.addConstr(7 * x1 + 12 * x3 >= 23)
    model.addConstr(x2 + 12 * x3 >= 18)
    model.addConstr(3 * x0 + 7 * x1 + x2 + 12 * x3 >= 18)
    model.addConstr(4 * x0 + 9 * x2 >= 48)
    model.addConstr(4 * x0 + 12 * x1 >= 22)
    model.addConstr(4 * x0 + 7 * x3 >= 37)
    model.addConstr(4 * x0 + 12 * x1 + 7 * x3 >= 46)
    model.addConstr(12 * x1 + 9 * x2 + 7 * x3 >= 46)
    model.addConstr(4 * x0 + 9 * x2 + 7 * x3 >= 46)
    model.addConstr(4 * x0 + 12 * x1 + 9 * x2 >= 46)
    model.addConstr(4 * x0 + 12 * x1 + 7 * x3 >= 50)
    model.addConstr(12 * x1 + 9 * x2 + 7 * x3 >= 50)
    model.addConstr(4 * x0 + 9 * x2 + 7 * x3 >= 50)
    model.addConstr(4 * x0 + 12 * x1 + 9 * x2 >= 50)
    model.addConstr(4 * x0 + 12 * x1 + 7 * x3 >= 53)
    model.addConstr(12 * x1 + 9 * x2 + 7 * x3 >= 53)
    model.addConstr(4 * x0 + 9 * x2 + 7 * x3 >= 53)
    model.addConstr(4 * x0 + 12 * x1 + 9 * x2 >= 53)
    model.addConstr(4 * x0 + 12 * x1 + 7 * x3 >= 51)
    model.addConstr(12 * x1 + 9 * x2 + 7 * x3 >= 51)
    model.addConstr(4 * x0 + 9 * x2 + 7 * x3 >= 51)
    model.addConstr(4 * x0 + 12 * x1 + 9 * x2 >= 51)
    model.addConstr(4 * x0 + 12 * x1 + 9 * x2 + 7 * x3 >= 51)
    model.addConstr(4 * x0 + 4 * x3 >= 24)
    model.addConstr(12 * x1 + 5 * x2 >= 10)
    model.addConstr(4 * x0 + 12 * x1 >= 16)
    model.addConstr(4 * x0 + 12 * x1 + 5 * x2 + 4 * x3 >= 16)
    model.addConstr(x1 + 6 * x2 >= 29)
    model.addConstr(9 * x0 + 2 * x3 >= 24)
    model.addConstr(x1 + 2 * x3 >= 25)
    model.addConstr(9 * x0 + 6 * x2 >= 18)
    model.addConstr(9 * x0 + x1 + 6 * x2 + 2 * x3 >= 18)
    model.addConstr(-x1 + x2 >= 0)
    model.addConstr(3 * x0 + 7 * x1 <= 67)
    model.addConstr(3 * x0 + 7 * x1 + 12 * x3 <= 39)
    model.addConstr(3 * x0 + x2 + 12 * x3 <= 77)
    model.addConstr(7 * x1 + x2 + 12 * x3 <= 87)
    model.addConstr(12 * x1 + 9 * x2 + 7 * x3 <= 152)
    model.addConstr(4 * x0 + 5 * x2 <= 99)
    model.addConstr(12 * x1 + 4 * x3 <= 25)
    model.addConstr(5 * x2 + 4 * x3 <= 62)
    model.addConstr(4 * x0 + 12 * x1 <= 41)
    model.addConstr(12 * x1 + 5 * x2 + 4 * x3 <= 59)
    model.addConstr(4 * x0 + 12 * x1 + 4 * x3 <= 87)
    model.addConstr(9 * x0 + 2 * x3 <= 117)
    model.addConstr(x1 + 6 * x2 + 2 * x3 <= 137)
    model.addConstr(9 * x0 + x1 + 2 * x3 <= 140)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by George: {x0.varValue}")
        print(f"Hours worked by Paul: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Hours worked by Mary: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
