
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b3 = m.addVar(lb=0, name="vitamin_b3")
vitamin_d = m.addVar(lb=0, name="vitamin_d")
potassium = m.addVar(lb=0, name="potassium")
vitamin_b6 = m.addVar(lb=0, name="vitamin_b6")
vitamin_b2 = m.addVar(lb=0, name="vitamin_b2")


# Set objective function
m.setObjective(7.11 * vitamin_b3 + 9.35 * vitamin_d + 8.61 * potassium + 9.94 * vitamin_b6 + 6.74 * vitamin_b2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * vitamin_b3 + 3 * vitamin_b2 >= 6)
m.addConstr(3 * vitamin_b3 + 5 * vitamin_d >= 15)
m.addConstr(5 * vitamin_b6 + 3 * vitamin_b2 >= 14)
m.addConstr(5 * vitamin_d + 2 * potassium >= 10)
m.addConstr(3 * vitamin_b3 + 2 * potassium >= 6)
m.addConstr(2 * potassium + 3 * vitamin_b2 >= 18)
m.addConstr(5 * vitamin_d + 5 * vitamin_b6 >= 13)
m.addConstr(3 * vitamin_b3 + 5 * vitamin_b6 >= 15)
m.addConstr(3 * vitamin_b3 + 5 * vitamin_d + 5 * vitamin_b6 >= 11)
m.addConstr(3 * vitamin_b3 + 5 * vitamin_d + 2 * potassium + 5 * vitamin_b6 + 3 * vitamin_b2 >= 11)
m.addConstr(2 * potassium + 2 * vitamin_b2 >= 13)
m.addConstr(6 * vitamin_d + 2 * potassium >= 12)
m.addConstr(5 * vitamin_b3 + 2 * vitamin_b2 >= 7)
m.addConstr(5 * vitamin_b3 + 2 * potassium >= 20)
m.addConstr(2 * potassium + 2 * vitamin_b6 >= 15)
m.addConstr(6 * vitamin_d + 2 * potassium + 2 * vitamin_b2 >= 11)
m.addConstr(6 * vitamin_d + 2 * potassium + 2 * vitamin_b6 >= 11)
m.addConstr(5 * vitamin_b3 + 6 * vitamin_d + 2 * potassium >= 11)
m.addConstr(5 * vitamin_b3 + 2 * vitamin_b6 + 2 * vitamin_b2 >= 11)
m.addConstr(5 * vitamin_b3 + 2 * potassium + 2 * vitamin_b2 >= 11)
m.addConstr(2 * potassium + 2 * vitamin_b6 + 2 * vitamin_b2 >= 11)
m.addConstr(5 * vitamin_b3 + 2 * potassium + 2 * vitamin_b6 >= 11)
m.addConstr(6 * vitamin_d + 2 * vitamin_b6 + 2 * vitamin_b2 >= 11)

# ... (rest of the constraints from the JSON, adapted similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

