
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["John", "Mary", "Bill", "George", "Jean"])

# Set objective function
m.setObjective(4 * x[0] + 2 * x[1] + x[2] + 3 * x[3] + 9 * x[4], gp.GRB.MAXIMIZE)

# Add constraints

# likelihood to quit index constraints
m.addConstr(13 * x[1] + 20 * x[3] + 21 * x[4] >= 68)
m.addConstr(13 * x[0] + 20 * x[1] + 13 * x[2] >= 68)
m.addConstr(13 * x[0] + 20 * x[3] + 21 * x[4] >= 68)
m.addConstr(20 * x[1] + 13 * x[2] + 21 * x[4] >= 68)
m.addConstr(13 * x[0] + 13 * x[2] + 20 * x[3] >= 68)
m.addConstr(13 * x[0] + 13 * x[2] + 21 * x[4] >= 68)
m.addConstr(20 * x[1] + 13 * x[2] + 20 * x[3] >= 68)

# Additional constraints (simplified to avoid redundancy)
m.addConstr(13 * x[1] + 20 * x[3] + 21 * x[4] >= 75)  # Combines all >= constraints for this group
m.addConstr(13 * x[0] + 20 * x[1] + 13 * x[2] >= 75) # Combines all >= constraints for this group
m.addConstr(13 * x[0] + 20 * x[3] + 21 * x[4] >= 75) # Combines all >= constraints for this group
m.addConstr(20 * x[1] + 13 * x[2] + 21 * x[4] >= 75) # Combines all >= constraints for this group
m.addConstr(13 * x[0] + 13 * x[2] + 20 * x[3] >= 75) # Combines all >= constraints for this group
m.addConstr(13 * x[0] + 13 * x[2] + 21 * x[4] >= 75) # Combines all >= constraints for this group
m.addConstr(20 * x[1] + 13 * x[2] + 20 * x[3] >= 75) # Combines all >= constraints for this group


m.addConstr(-7 * x[0] + 7 * x[2] >= 0)
m.addConstr(-10 * x[1] - 3 * x[3] + 4 * x[4] >= 0)
m.addConstr(20 * x[1] + 13 * x[2] <= 124)
m.addConstr(13 * x[0] + 20 * x[1] <= 340)
m.addConstr(13 * x[2] + 20 * x[3] <= 86)
m.addConstr(13 * x[0] + 20 * x[3] <= 327)
m.addConstr(20 * x[1] + 13 * x[2] + 21 * x[4] <= 124)
m.addConstr(13 * x[0] + 20 * x[1] + 13 * x[2] <= 354)
m.addConstr(13 * x[0] + 20 * x[1] + 21 * x[4] <= 359)
m.addConstr(13 * x[0] + 13 * x[2] + 20 * x[3] <= 226)
m.addConstr(13 * x[2] + 20 * x[3] + 21 * x[4] <= 129)
m.addConstr(13 * x[0] + 20 * x[1] + 20 * x[3] <= 385)
m.addConstr(13 * x[0] + 20 * x[1] + 13 * x[2] + 20 * x[3] + 21 * x[4] <= 385)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

