
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='x1', lb=0)  # hours worked by John
x2 = m.addVar(name='x2', lb=0)  # hours worked by Mary
x3 = m.addVar(name='x3', lb=0)  # hours worked by Bill
x4 = m.addVar(name='x4', lb=0)  # hours worked by George
x5 = m.addVar(name='x5', lb=0)  # hours worked by Jean

# Objective function
m.setObjective(4*x1 + 2*x2 + x3 + 3*x4 + 9*x5, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(13*x1 <= 401)
m.addConstr(20*x2 <= 401)
m.addConstr(13*x3 <= 401)
m.addConstr(20*x4 <= 401)
m.addConstr(21*x5 <= 401)

m.addConstr(20*x2 + 20*x4 + 21*x5 >= 68)
m.addConstr(13*x1 + 20*x2 + 13*x3 >= 68)
m.addConstr(13*x1 + 20*x4 + 21*x5 >= 68)
m.addConstr(20*x2 + 13*x3 + 21*x5 >= 68)
m.addConstr(13*x1 + 13*x3 + 20*x4 >= 68)
m.addConstr(13*x1 + 13*x3 + 21*x5 >= 68)
m.addConstr(20*x2 + 13*x3 + 20*x4 >= 68)

# ... add all constraints

m.addConstr(-7*x1 + 7*x3 >= 0)
m.addConstr(-10*x2 - 3*x4 + 4*x5 >= 0)

m.addConstr(20*x2 + 13*x3 <= 124)
m.addConstr(13*x1 + 20*x2 <= 340)
m.addConstr(13*x3 + 20*x4 <= 86)
m.addConstr(13*x1 + 20*x4 <= 327)
m.addConstr(20*x2 + 13*x3 + 21*x5 <= 124)
m.addConstr(13*x1 + 20*x2 + 13*x3 <= 354)
m.addConstr(13*x1 + 20*x2 + 21*x5 <= 359)
m.addConstr(13*x1 + 13*x3 + 20*x4 <= 226)
m.addConstr(13*x3 + 20*x4 + 21*x5 <= 129)
m.addConstr(13*x1 + 20*x2 + 20*x4 <= 385)
m.addConstr(13*x1 + 20*x2 + 13*x3 + 20*x4 + 21*x5 <= 385)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objval)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
    print('x5: ', x5.varValue)
else:
    print('No solution found')
