
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="knishes", lb=0, ub=None)
x1 = model.addVar(name="chicken_drumsticks", lb=0, integer=True)
x2 = model.addVar(name="steaks", lb=0, integer=True)

# Set the objective function
model.setObjective(9.54 * x0 + 1.56 * x1 + 4.96 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(23 * x0 + 2 * x1 + 7 * x2 <= 133)
model.addConstr(15 * x0 + 3 * x1 + 23 * x2 <= 145)
model.addConstr(13 * x0 + 5 * x1 + 24 * x2 <= 240)
model.addConstr(15 * x0 + 20 * x1 + 15 * x2 <= 168)
model.addConstr(23 * x0 + 7 * x2 >= 20)
model.addConstr(2 * x1 + 7 * x2 >= 37)
model.addConstr(23 * x0 + 2 * x1 + 7 * x2 >= 34)
model.addConstr(15 * x0 + 3 * x1 >= 20)
model.addConstr(15 * x0 + 3 * x1 + 23 * x2 >= 20)
model.addConstr(13 * x0 + 5 * x1 >= 26)
model.addConstr(13 * x0 + 24 * x2 >= 67)
model.addConstr(5 * x1 + 24 * x2 >= 36)
model.addConstr(13 * x0 + 5 * x1 + 24 * x2 >= 36)
model.addConstr(15 * x0 + 20 * x1 >= 25)
model.addConstr(15 * x0 + 15 * x2 >= 34)
model.addConstr(15 * x0 + 20 * x1 + 15 * x2 >= 34)
model.addConstr(7 * x0 - 7 * x2 >= 0)
model.addConstr(15 * x0 + 23 * x2 <= 102)
model.addConstr(15 * x0 + 3 * x1 + 23 * x2 <= 139)
model.addConstr(13 * x0 + 5 * x1 + 24 * x2 <= 194)
model.addConstr(15 * x0 + 20 * x1 <= 143)
model.addConstr(20 * x1 + 15 * x2 <= 88)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Knishes: ", x0.varValue)
    print("Chicken Drumsticks: ", x1.varValue)
    print("Steaks: ", x2.varValue)
else:
    print("The model is infeasible")
