
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x = m.addVars(5, lb=0, names=['B7', 'C', 'Zinc', 'B5', 'B2'])
x[0].vtype = gp.GRB.INTEGER  # B7 is integer
x[2].vtype = gp.GRB.INTEGER  # Zinc is integer


# Set objective function
m.setObjective(8.81 * x[0] + 1.33 * x[1] + 1.35 * x[2] + 4.57 * x[3] + 5.85 * x[4], gp.GRB.MINIMIZE)

# Resource coefficients
resource_coeffs = {
    'r0': {'upper_bound': 450, 'coeffs': [20, 27, 23, 27, 32]},
    'r1': {'upper_bound': 242, 'coeffs': [25, 8, 11, 28, 16]},
    'r2': {'upper_bound': 531, 'coeffs': [13, 23, 19, 16, 11]},
    'r3': {'upper_bound': 774, 'coeffs': [6, 13, 12, 22, 24]},
    'r4': {'upper_bound': 645, 'coeffs': [27, 8, 29, 23, 32]}
}

# Add resource constraints
for resource, data in resource_coeffs.items():
    m.addConstr(gp.quicksum(data['coeffs'][i] * x[i] for i in range(5)) <= data['upper_bound'], resource)


# Add other constraints (extracted from the problem description and converted to symbolic form)
constraints = [
    # ... (all the constraints from the JSON "constraints" field)
]

for constraint_str in constraints:
    m.addConstr(eval(constraint_str))  # Use eval() to parse the constraint string


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f'Optimization ended with status {m.status}')

