
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B7
    x1 = model.addVar(name='x1')  # milligrams of vitamin C
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # milligrams of zinc
    x3 = model.addVar(name='x3')  # milligrams of vitamin B5
    x4 = model.addVar(name='x4')  # milligrams of vitamin B2

    # Objective function
    model.setObjective(8.81 * x0 + 1.33 * x1 + 1.35 * x2 + 4.57 * x3 + 5.85 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * x0 <= 450)
    model.addConstr(25 * x0 <= 242)
    model.addConstr(13 * x0 <= 531)
    model.addConstr(6 * x0 <= 774)
    model.addConstr(27 * x0 <= 645)
    model.addConstr(27 * x1 <= 450)
    model.addConstr(8 * x1 <= 242)
    model.addConstr(23 * x1 <= 531)
    model.addConstr(13 * x1 <= 774)
    model.addConstr(8 * x1 <= 645)
    model.addConstr(23 * x2 <= 450)
    model.addConstr(11 * x2 <= 242)
    model.addConstr(19 * x2 <= 531)
    model.addConstr(12 * x2 <= 774)
    model.addConstr(29 * x2 <= 645)
    model.addConstr(27 * x3 <= 450)
    model.addConstr(28 * x3 <= 242)
    model.addConstr(16 * x3 <= 531)
    model.addConstr(22 * x3 <= 774)
    model.addConstr(23 * x3 <= 645)
    model.addConstr(32 * x4 <= 450)
    model.addConstr(16 * x4 <= 242)
    model.addConstr(11 * x4 <= 531)
    model.addConstr(24 * x4 <= 774)
    model.addConstr(32 * x4 <= 645)
    model.addConstr(23 * x2 + 32 * x4 >= 87)
    model.addConstr(23 * x2 + 27 * x3 >= 47)
    model.addConstr(27 * x1 + 23 * x2 + 27 * x3 >= 74)

    # Solve model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found")
        print("Objective value:", model.objval)
        print("x0:", x0.varValue)
        print("x1:", x1.varValue)
        print("x2:", x2.varValue)
        print("x3:", x3.varValue)
        print("x4:", x4.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
