
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    rubber_bands = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_bands")
    monochrome_printers = m.addVar(vtype=gp.GRB.INTEGER, name="monochrome_printers")
    cans_of_coffee = m.addVar(vtype=gp.GRB.INTEGER, name="cans_of_coffee")

    # Set objective function
    m.setObjective(5*rubber_bands + 7*monochrome_printers + 4*cans_of_coffee, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(19*rubber_bands + 9*cans_of_coffee >= 67, "c1")
    m.addConstr(2*monochrome_printers + 9*cans_of_coffee >= 105, "c2")
    m.addConstr(19*rubber_bands + 2*monochrome_printers >= 61, "c3")
    m.addConstr(19*rubber_bands + 2*monochrome_printers + 9*cans_of_coffee >= 67, "c4")
    m.addConstr(-8*rubber_bands + 5*cans_of_coffee >= 0, "c5")
    m.addConstr(-1*monochrome_printers + 8*cans_of_coffee >= 0, "c6")
    m.addConstr(19*rubber_bands + 9*cans_of_coffee <= 311, "c7")
    m.addConstr(19*rubber_bands + 2*monochrome_printers <= 174, "c8")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        print('rubber_bands:', rubber_bands.x)
        print('monochrome_printers:', monochrome_printers.x)
        print('cans_of_coffee:', cans_of_coffee.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

