
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="rubber_bands")
x2 = m.addVar(vtype=GRB.INTEGER, name="monochrome_printers")
x3 = m.addVar(vtype=GRB.INTEGER, name="cans_of_coffee")

# Define the objective function
m.setObjective(5*x1 + 7*x2 + 4*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(19*x1 + 9*x3 >= 67, "usefulness_rubber_coffee")
m.addConstr(2*x2 + 9*x3 >= 105, "usefulness_printers_coffee")
m.addConstr(19*x1 + 2*x2 >= 61, "usefulness_rubber_printers")
m.addConstr(19*x1 + 2*x2 + 9*x3 >= 67, "total_usefulness_min")
m.addConstr(-8*x1 + 5*x3 >= 0, "rubber_coffee_constraint")
m.addConstr(-x2 + 8*x3 >= 0, "printers_coffee_constraint")
m.addConstr(19*x1 + 9*x3 <= 311, "usefulness_rubber_coffee_max")
m.addConstr(19*x1 + 2*x2 <= 174, "usefulness_rubber_printers_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rubber bands: {x1.x}")
    print(f"Monochrome printers: {x2.x}")
    print(f"Cans of coffee: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
