
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="rubber_bands", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="monochrome_printers", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="cans_of_coffee", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5*x1 + 7*x2 + 4*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(19*x1 + 9*x3 >= 67)
m.addConstr(2*x2 + 9*x3 >= 105)
m.addConstr(19*x1 + 2*x2 >= 61)
m.addConstr(19*x1 + 2*x2 + 9*x3 >= 67)
m.addConstr(-8*x1 + 5*x3 >= 0)
m.addConstr(-x2 + 8*x3 >= 0)
m.addConstr(19*x1 + 9*x3 <= 311)
m.addConstr(19*x1 + 2*x2 <= 174)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Rubber bands: ", x1.varValue)
    print("Monochrome printers: ", x2.varValue)
    print("Cans of coffee: ", x3.varValue)
else:
    print("The problem is infeasible")
