
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by George
    x1 = model.addVar(name="x1", lb=0)  # hours worked by John
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Hank
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Bobby
    x4 = model.addVar(name="x4", lb=0)  # hours worked by Mary
    x5 = model.addVar(name="x5", lb=0)  # hours worked by Paul

    # Objective function
    model.setObjective(2*x0 + 2*x1 + 8*x2 + x3 + 2*x4 + 5*x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14*x0 >= 14)
    model.addConstr(6*x0 >= 6)
    model.addConstr(7*x1 >= 7)
    model.addConstr(14*x1 >= 14)
    model.addConstr(x2 >= 1)
    model.addConstr(5*x2 >= 5)
    model.addConstr(6*x3 >= 6)
    model.addConstr(x3 >= 1)
    model.addConstr(x4 >= 1)
    model.addConstr(x4 >= 1)
    model.addConstr(6*x5 >= 6)
    model.addConstr(x3 + x2 >= 49)
    model.addConstr(14*x0 + x2 >= 31)
    model.addConstr(7*x1 + 6*x5 >= 50)
    model.addConstr(7*x1 + x3 >= 24)
    model.addConstr(14*x0 + 7*x1 >= 35)
    model.addConstr(7*x1 + x2 >= 61)
    model.addConstr(x3 + x4 >= 62)
    model.addConstr(6*x3 + x4 + 6*x5 >= 39)
    model.addConstr(14*x0 + 7*x1 + 6*x5 >= 39)

    # Add more constraints here...

    # The total combined organization score from hours worked by George plus hours worked by John has to be 91 at a maximum.
    model.addConstr(14*x0 + 7*x1 <= 91)

    # The total combined organization score from hours worked by Hank plus hours worked by Bobby plus hours worked by Paul has to be equal to or less than 141.
    model.addConstr(x2 + x3 + 6*x5 <= 141)

    # The total combined organization score from hours worked by John plus hours worked by Hank plus hours worked by Bobby has to be  no more than 138.
    model.addConstr(7*x1 + x2 + x3 <= 138)

    # The total combined computer competence rating from hours worked by George and hours worked by John must be equal to or less than 206.
    model.addConstr(6*x0 + 14*x1 <= 206)

    # The total combined computer competence rating from hours worked by Hank and hours worked by Bobby has to be 280 or less.
    model.addConstr(5*x2 + x3 <= 280)

    # The total combined computer competence rating from hours worked by George, and hours worked by Bobby has to be at most 332.
    model.addConstr(6*x0 + x3 <= 332)

    # The total combined computer competence rating from hours worked by George plus hours worked by Hank has to be less than or equal to 168.
    model.addConstr(6*x0 + 5*x2 <= 168)

    # The total combined computer competence rating from hours worked by Bobby plus hours worked by Paul should be 455 or less.
    model.addConstr(x3 + 6*x5 <= 455)

    # The total combined computer competence rating from hours worked by John plus hours worked by Mary should be equal to or less than 450.
    model.addConstr(14*x1 + x4 <= 450)

    # The total combined computer competence rating from hours worked by Hank plus hours worked by Paul must be as much or less than 376.
    model.addConstr(5*x2 + 6*x5 <= 376)

    # The total combined computer competence rating from hours worked by John plus hours worked by Hank must be 161 at a maximum.
    model.addConstr(14*x1 + 5*x2 <= 161)

    # The total combined computer competence rating from hours worked by John and hours worked by Bobby must be 167 at a maximum.
    model.addConstr(14*x1 + x3 <= 167)

    # The total combined computer competence rating from hours worked by Mary plus hours worked by Paul should be 264 at a maximum.
    model.addConstr(x4 + 6*x5 <= 264)

    # -6 times the number of hours worked by George, plus 2 times the number of hours worked by Bobby has to be greater than or equal to zero.
    model.addConstr(-6*x0 + 2*x3 >= 0)

    # -6 times the number of hours worked by Bobby, plus 3 times the number of hours worked by Mary has to be no less than zero.
    model.addConstr(-6*x3 + 3*x4 >= 0)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by George:", x0.varValue)
        print("Hours worked by John:", x1.varValue)
        print("Hours worked by Hank:", x2.varValue)
        print("Hours worked by Bobby:", x3.varValue)
        print("Hours worked by Mary:", x4.varValue)
        print("Hours worked by Paul:", x5.varValue)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
