
import gurobipy as gp

# Create a new model
m = gp.Model("carbohydrate_optimization")

# Create variables
lemons = m.addVar(lb=0, vtype='C', name="lemons")
potatoes = m.addVar(lb=0, vtype='C', name="potatoes")
ravioli = m.addVar(lb=0, vtype='C', name="ravioli")
black_beans = m.addVar(lb=0, vtype='C', name="black_beans")

# Set objective function
m.setObjective(7.44*lemons**2 + 5.02*lemons*potatoes + 1.88*lemons*ravioli + 2.78*potatoes + 7.87*ravioli + 8.79*black_beans, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*lemons + 20*potatoes + 15*ravioli + 4*black_beans <= 246, "c0")
m.addConstr(potatoes**2 + ravioli**2 >= 29, "c1")
m.addConstr(11*lemons + 15*ravioli >= 37, "c2")
m.addConstr(15*ravioli + 4*black_beans <= 86, "c3")
m.addConstr(20*potatoes + 4*black_beans <= 218, "c4")
m.addConstr(11*lemons**2 + 20*potatoes**2 <= 185, "c5")


m.addConstr(11*lemons + 20*potatoes + 15*ravioli + 4*black_beans <= 185, "c6")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('lemons:', lemons.x)
    print('potatoes:', potatoes.x)
    print('ravioli:', ravioli.x)
    print('black_beans:', black_beans.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

