
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="lemons", lb=0) 
x2 = model.addVar(name="potatoes", lb=0)
x3 = model.addVar(name="ravioli", lb=0)
x4 = model.addVar(name="black_beans", lb=0)

# Objective function
model.setObjective(7.44 * x1**2 + 5.02 * x1 * x2 + 1.88 * x1 * x3 + 2.78 * x2 + 7.87 * x3 + 8.79 * x4, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(11 * x1 + 20 * x2 + 15 * x3 + 4 * x4 <= 246, name="carbohydrates")
model.addConstr(20 * x2**2 + 15 * x3**2 >= 29, name="potatoes_ravioli_squared")
model.addConstr(11 * x1 + 15 * x3 >= 37, name="lemons_ravioli")
model.addConstr(15 * x3 + 4 * x4 <= 86, name="ravioli_black_beans")
model.addConstr(20 * x2 + 4 * x4 <= 218, name="potatoes_black_beans")
model.addConstr(121 * x1**2 + 400 * x2**2 <= 185, name="lemons_squared_potatoes_squared")
model.addConstr(11 * x1 + 20 * x2 + 15 * x3 + 4 * x4 <= 185, name="total_carbohydrates")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Lemons: ", x1.varValue)
    print("Potatoes: ", x2.varValue)
    print("Ravioli: ", x3.varValue)
    print("Black Beans: ", x4.varValue)
else:
    print("The model is infeasible")
