
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
lemons = m.addVar(lb=0, name="lemons")
ham_sandwiches = m.addVar(lb=0, name="ham_sandwiches")
cherry_pies = m.addVar(lb=0, name="cherry_pies")
fruit_salads = m.addVar(lb=0, name="fruit_salads")


# Set objective function
m.setObjective(7.26 * lemons + 6.62 * ham_sandwiches + 1.42 * cherry_pies + 2.56 * fruit_salads, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5.8 * lemons + 8.4 * fruit_salads >= 27)
m.addConstr(2.9 * cherry_pies + 8.4 * fruit_salads >= 37)
m.addConstr(3.85 * ham_sandwiches + 8.4 * fruit_salads >= 30)
m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies >= 31)
m.addConstr(5.8 * lemons + 2.9 * cherry_pies + 8.4 * fruit_salads >= 31)
m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies >= 41)
m.addConstr(5.8 * lemons + 2.9 * cherry_pies + 8.4 * fruit_salads >= 41)
m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies + 8.4 * fruit_salads >= 41)
m.addConstr(5.15 * lemons + 7.62 * fruit_salads >= 27)
m.addConstr(5.15 * lemons + 3.63 * ham_sandwiches >= 24)
m.addConstr(3.3 * cherry_pies + 7.62 * fruit_salads >= 47)
m.addConstr(3.63 * ham_sandwiches + 3.3 * cherry_pies >= 38)
m.addConstr(5.15 * lemons + 3.3 * cherry_pies + 7.62 * fruit_salads >= 32)
m.addConstr(5.15 * lemons + 3.63 * ham_sandwiches + 3.3 * cherry_pies + 7.62 * fruit_salads >= 32)
m.addConstr(-6 * cherry_pies + 7 * fruit_salads >= 0)
m.addConstr(2 * ham_sandwiches - cherry_pies >= 0)
m.addConstr(5.8 * lemons + 2.9 * cherry_pies <= 130)
m.addConstr(2.9 * cherry_pies + 8.4 * fruit_salads <= 169)
m.addConstr(3.85 * ham_sandwiches + 2.9 * cherry_pies <= 181)
m.addConstr(3.85 * ham_sandwiches + 8.4 * fruit_salads <= 73)
m.addConstr(5.15 * lemons + 3.3 * cherry_pies + 7.62 * fruit_salads <= 68)

m.addConstr(5.8 * lemons + 3.85 * ham_sandwiches + 2.9 * cherry_pies + 8.4 * fruit_salads <= 207)
m.addConstr(5.15 * lemons + 3.63 * ham_sandwiches + 3.3 * cherry_pies + 7.62 * fruit_salads <= 206)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

