
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="lemons", lb=0)  # No lower bound specified, but can be fractional
x1 = m.addVar(name="ham sandwiches", lb=0)  # No lower bound specified, but can be fractional
x2 = m.addVar(name="cherry pies", lb=0)  # No lower bound specified, but can be fractional
x3 = m.addVar(name="fruit salads", lb=0)  # No lower bound specified, but can be fractional

# Objective function
m.setObjective(7.26 * x0 + 6.62 * x1 + 1.42 * x2 + 2.56 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5.8 * x0 + 8.4 * x3 >= 27)
m.addConstr(2.9 * x2 + 8.4 * x3 >= 37)
m.addConstr(3.85 * x1 + 8.4 * x3 >= 30)
m.addConstr(5.8 * x0 + 3.85 * x1 + 2.9 * x2 >= 31)
m.addConstr(5.8 * x0 + 2.9 * x2 + 8.4 * x3 >= 31)
m.addConstr(5.8 * x0 + 3.85 * x1 + 2.9 * x2 >= 41)
m.addConstr(5.8 * x0 + 2.9 * x2 + 8.4 * x3 >= 41)
m.addConstr(5.8 * x0 + 3.85 * x1 + 2.9 * x2 + 8.4 * x3 >= 41)
m.addConstr(5.15 * x0 + 7.62 * x3 >= 27)
m.addConstr(5.15 * x0 + 3.63 * x1 >= 24)
m.addConstr(3.3 * x2 + 7.62 * x3 >= 47)
m.addConstr(3.63 * x1 + 3.3 * x2 >= 38)
m.addConstr(5.15 * x0 + 3.3 * x2 + 7.62 * x3 >= 32)
m.addConstr(5.15 * x0 + 3.63 * x1 + 3.3 * x2 + 7.62 * x3 >= 32)
m.addConstr(-6 * x2 + 7 * x3 >= 0)
m.addConstr(2 * x1 - x2 >= 0)
m.addConstr(5.8 * x0 + 2.9 * x2 <= 130)
m.addConstr(2.9 * x2 + 8.4 * x3 <= 169)
m.addConstr(3.85 * x1 + 2.9 * x2 <= 181)
m.addConstr(3.85 * x1 + 8.4 * x3 <= 73)
m.addConstr(5.15 * x0 + 3.3 * x2 + 7.62 * x3 <= 68)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Lemons: ", x0.varValue)
    print("Ham sandwiches: ", x1.varValue)
    print("Cherry pies: ", x2.varValue)
    print("Fruit salads: ", x3.varValue)
else:
    print("The model is infeasible.")
