
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
chrysanthemums = m.addVar(vtype=GRB.INTEGER, name="chrysanthemums")
daisies = m.addVar(vtype=GRB.INTEGER, name="daisies")
aloe_vera = m.addVar(vtype=GRB.INTEGER, name="aloe_vera")
hydrangeas = m.addVar(vtype=GRB.INTEGER, name="hydrangeas")
cherry_trees = m.addVar(vtype=GRB.INTEGER, name="cherry_trees")


# Set objective function
m.setObjective(chrysanthemums**2 + 6*chrysanthemums*daisies + 5*chrysanthemums*aloe_vera + chrysanthemums*hydrangeas + 9*chrysanthemums*cherry_trees + 7*daisies**2 + 4*daisies*aloe_vera + 6*daisies*hydrangeas + daisies*cherry_trees + 6*aloe_vera**2 + 6*aloe_vera*hydrangeas + 3*aloe_vera*cherry_trees + 7*hydrangeas**2 + 3*hydrangeas*cherry_trees + cherry_trees**2 + 6*chrysanthemums + daisies + 8*aloe_vera + 9*hydrangeas + 9*cherry_trees, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*chrysanthemums + 7*daisies + 7*aloe_vera + 22*hydrangeas + 3*cherry_trees <= 182, "c0")
m.addConstr(22*chrysanthemums + 17*daisies + 18*aloe_vera + 7*hydrangeas + 18*cherry_trees <= 385, "c1")
m.addConstr((9*chrysanthemums)**2 + (7*daisies)**2 >= 35, "c2")
m.addConstr(9*chrysanthemums + 3*cherry_trees >= 32, "c3")
m.addConstr(7*daisies + 3*cherry_trees >= 12, "c4")
m.addConstr(7*aloe_vera + 22*hydrangeas >= 21, "c5")
m.addConstr(9*chrysanthemums + 7*daisies + 22*hydrangeas >= 30, "c6")
m.addConstr(22*(chrysanthemums**2) + 7*(hydrangeas**2) >= 33, "c7")
m.addConstr(18*(aloe_vera**2) + 7*(hydrangeas**2) >= 25, "c8")
m.addConstr(22*chrysanthemums + 18*cherry_trees >= 46, "c9")
m.addConstr(7*hydrangeas + 18*cherry_trees >= 34, "c10")
m.addConstr(22*(chrysanthemums**2) + 17*(daisies**2) >= 48, "c11")
m.addConstr(18*(aloe_vera**2) + 18*(cherry_trees**2) >= 32, "c12")
m.addConstr(7*chrysanthemums - 5*cherry_trees >= 0, "c13")
m.addConstr(9*chrysanthemums + 7*daisies <= 129, "c14")
m.addConstr((7*daisies)**2 + (22*hydrangeas)**2 <= 128, "c15")
m.addConstr(9*chrysanthemums + 22*hydrangeas <= 105, "c16")
m.addConstr(22*hydrangeas + 3*cherry_trees <= 138, "c17")
m.addConstr(9*chrysanthemums + 7*aloe_vera <= 179, "c18")
m.addConstr(9*chrysanthemums + 3*cherry_trees <= 104, "c19")
m.addConstr((7*aloe_vera)**2 + (3*cherry_trees)**2 <= 145, "c20")
m.addConstr((7*daisies)**2 + (22*hydrangeas)**2 + (3*cherry_trees)**2 <= 147, "c21")
m.addConstr((9*chrysanthemums)**2 + (7*aloe_vera)**2 + (3*cherry_trees)**2 <= 84, "c22")
m.addConstr(9*chrysanthemums + 7*daisies + 7*aloe_vera + 22*hydrangeas + 3*cherry_trees <= 84, "c23")
m.addConstr(22*chrysanthemums + 7*hydrangeas <= 257, "c24")
m.addConstr(17*daisies + 18*aloe_vera <= 246, "c25")
m.addConstr(22*chrysanthemums + 18*cherry_trees <= 259, "c26")
m.addConstr(22*chrysanthemums + 17*daisies + 18*aloe_vera + 7*hydrangeas + 18*cherry_trees <= 259, "c27")


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

