
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='chrysanthemums', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='daisies', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='aloe_vera', vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name='hydrangeas', vtype=gurobi.GRB.INTEGER)
x5 = m.addVar(name='cherry_trees', vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(1*x1**2 + 6*x1*x2 + 5*x1*x3 + 1*x1*x4 + 9*x1*x5 + 7*x2**2 + 4*x2*x3 + 6*x2*x4 + 1*x2*x5 + 6*x3**2 + 6*x3*x4 + 3*x3*x5 + 7*x4**2 + 3*x4*x5 + 1*x5**2 + 6*x1 + 1*x2 + 8*x3 + 9*x4 + 9*x5, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*x1 <= 182)
m.addConstr(22*x1 <= 385)
m.addConstr(7*x2 <= 182)
m.addConstr(17*x2 <= 385)
m.addConstr(7*x3 <= 182)
m.addConstr(18*x3 <= 385)
m.addConstr(22*x4 <= 182)
m.addConstr(7*x4 <= 385)
m.addConstr(3*x5 <= 182)
m.addConstr(18*x5 <= 385)
m.addConstr(x1**2 + x2**2 >= 35)
m.addConstr(x1 + x5 >= 32)
m.addConstr(x2 + x5 >= 12)
m.addConstr(x3 + x4 >= 21)
m.addConstr(x1 + x2 + x4 >= 30)
m.addConstr(x1**2 + x4**2 >= 33)
m.addConstr(x3**2 + x4**2 >= 25)
m.addConstr(x1 + x5 >= 46)
m.addConstr(x4 + x5 >= 34)
m.addConstr(x1**2 + x2**2 >= 48)
m.addConstr(x3**2 + x5**2 >= 32)
m.addConstr(7*x1 - 5*x5 >= 0)
m.addConstr(x1 + x2 <= 129)
m.addConstr(x2**2 + x4**2 <= 128)
m.addConstr(x1 + x4 <= 105)
m.addConstr(x4 + x5 <= 138)
m.addConstr(x1 + x3 <= 179)
m.addConstr(x1 + x5 <= 104)
m.addConstr(x3**2 + x5**2 <= 145)
m.addConstr(x2**2 + x4**2 + x5**2 <= 147)
m.addConstr(x1**2 + x3**2 + x5**2 <= 84)
m.addConstr(x1 + x2 + x3 + x4 + x5 <= 84)
m.addConstr(22*x1 + 7*x4 <= 257)
m.addConstr(17*x2 + 18*x3 <= 246)
m.addConstr(22*x1 + 18*x5 <= 259)
m.addConstr(22*x1 + 17*x2 + 18*x3 + 7*x4 + 18*x5 <= 259)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('chrysanthemums: ', x1.varValue)
    print('daisies: ', x2.varValue)
    print('aloe_vera: ', x3.varValue)
    print('hydrangeas: ', x4.varValue)
    print('cherry_trees: ', x5.varValue)
else:
    print('No solution found')
