
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    steaks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steaks")
    bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
    sashimi = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sashimi")
    green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")


    # Set objective function
    m.setObjective(1.91 * steaks + 5.34 * bacon + 5.06 * sashimi + 9.14 * green_beans, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8 * steaks + 6 * green_beans >= 19)
    m.addConstr(6 * bacon + 6 * green_beans >= 30)
    m.addConstr(8 * steaks + 7 * sashimi >= 47)
    m.addConstr(6 * bacon + 7 * sashimi >= 21)
    m.addConstr(8 * steaks + 6 * bacon + 7 * sashimi >= 41)
    m.addConstr(8 * steaks + 6 * bacon + 7 * sashimi + 6 * green_beans >= 41)
    m.addConstr(7 * bacon + 10 * sashimi >= 34)
    m.addConstr(10 * sashimi + 14 * green_beans >= 35)
    m.addConstr(7 * bacon + 14 * green_beans >= 20)
    m.addConstr(7 * steaks + 7 * bacon + 10 * sashimi + 14 * green_beans >= 20)
    m.addConstr(6 * sashimi + 15 * green_beans >= 17)
    m.addConstr(16 * steaks + 7 * bacon >= 45)
    m.addConstr(16 * steaks + 7 * bacon + 6 * sashimi + 15 * green_beans >= 45)
    m.addConstr(-6 * sashimi + 5 * green_beans >= 0)
    m.addConstr(7 * sashimi + 6 * green_beans <= 101)
    m.addConstr(8 * steaks + 6 * green_beans <= 160)
    m.addConstr(8 * steaks + 7 * sashimi + 6 * green_beans <= 142)
    m.addConstr(6 * bacon + 7 * sashimi + 6 * green_beans <= 78)
    m.addConstr(8 * steaks + 6 * bacon + 6 * green_beans <= 77)
    m.addConstr(16 * steaks + 6 * sashimi <= 147)
    m.addConstr(16 * steaks + 7 * bacon <= 126)
    m.addConstr(6 * sashimi + 15 * green_beans <= 124)
    m.addConstr(7 * bacon + 15 * green_beans <= 180)
    m.addConstr(7 * bacon + 6 * sashimi <= 143)

    # Resource Constraints
    m.addConstr(8 * steaks <= 195)
    m.addConstr(7 * steaks <= 178)
    m.addConstr(16 * steaks <= 205)
    m.addConstr(6 * bacon <= 195)
    m.addConstr(7 * bacon <= 178)
    m.addConstr(7 * bacon <= 205)
    m.addConstr(7 * sashimi <= 195)
    m.addConstr(10 * sashimi <= 178)
    m.addConstr(6 * sashimi <= 205)
    m.addConstr(6 * green_beans <= 195)
    m.addConstr(14 * green_beans <= 178)
    m.addConstr(15 * green_beans <= 205)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization was infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
