
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    paper_towel_rolls = m.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")
    lightbulbs = m.addVar(vtype=GRB.INTEGER, name="lightbulbs")


    # Set objective function
    m.setObjective(9.45 * paper_towel_rolls + 4.16 * lightbulbs, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(19 * paper_towel_rolls + 28 * lightbulbs >= 93, "c0")
    m.addConstr(19 * paper_towel_rolls + 28 * lightbulbs >= 93, "c1")
    m.addConstr(9 * paper_towel_rolls - 7 * lightbulbs >= 0, "c2")
    m.addConstr(19 * paper_towel_rolls + 28 * lightbulbs <= 114, "c3")



    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Paper Towel Rolls: {paper_towel_rolls.x}")
        print(f"Lightbulbs: {lightbulbs.x}")
        print(f"Objective Value: {m.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
