
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")
x2 = m.addVar(vtype=GRB.INTEGER, name="lightbulbs")

# Set the objective function
m.setObjective(9.45*x1 + 4.16*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(19*x1 + 28*x2 >= 93, "total_value_at_least_93")
m.addConstr(19*x1 + 28*x2 <= 114, "total_value_no_more_than_114")
m.addConstr(9*x1 - 7*x2 >= 0, "quantity_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Paper towel rolls: {x1.x}")
    print(f"Lightbulbs: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
