
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='paper_towel_rolls', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='lightbulbs', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9.45 * x1 + 4.16 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(19 * x1 + 28 * x2 >= 93)
    model.addConstr(9 * x1 - 7 * x2 >= 0)
    model.addConstr(19 * x1 + 28 * x2 <= 114)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Paper towel rolls: {x1.varValue}')
        print(f'Lightbulbs: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
