
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of calcium
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # milligrams of zinc
    x2 = m.addVar(vtype=GRB.INTEGER, name="x2") # milligrams of vitamin C


    # Set objective function
    m.setObjective(2.57*x0**2 + 9.67*x0*x1 + 5.9*x1**2 + 1.07*x2**2 + 5.17*x0, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x0 + 3*x1 + 3*x2 <= 50, "c0")
    m.addConstr(2*x0 + 8*x1 + 5*x2 <= 106, "c1")
    m.addConstr(11*x0 + 11*x1 + 9*x2 <= 81, "c2")
    m.addConstr(3*x1**2 + 3*x2**2 >= 8, "c3")
    m.addConstr(x0**2 + 3*x2**2 >= 10, "c4")
    m.addConstr(x0 + 3*x1 + 3*x2 >= 15, "c5")
    m.addConstr(2*x0**2 + 8*x1**2 >= 32, "c6")
    m.addConstr(11*x0**2 + 9*x2**2 >= 13, "c7")
    m.addConstr(3*x1**2 + 3*x2**2 <= 19, "c8")
    m.addConstr(x0 + 3*x1 <= 40, "c9")
    m.addConstr(x0 + 3*x1 + 3*x2 <= 40, "c10")
    m.addConstr(2*x0**2 + 8*x1**2 <= 55, "c11")
    m.addConstr(2*x0**2 + 5*x2**2 <= 79, "c12")
    m.addConstr(2*x0 + 8*x1 + 5*x2 <= 79, "c13")
    m.addConstr(11*x0 + 9*x2 <= 54, "c14")
    m.addConstr(11*x0 + 11*x1 + 9*x2 <= 54, "c15")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
