
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="milligrams_of_calcium", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="milligrams_of_zinc")
x3 = m.addVar(name="milligrams_of_vitamin_C", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(2.57*x1**2 + 9.67*x1*x2 + 5.9*x2**2 + 1.07*x3**2 + 5.17*x1, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x1 + 3*x2 + 3*x3 <= 50, name="kidney_support_index")
m.addConstr(2*x1 + 8*x2 + 5*x3 <= 106, name="muscle_growth_index")
m.addConstr(11*x1 + 11*x2 + 9*x3 <= 81, name="cardiovascular_support_index")
m.addConstr(3*x2 + 3*x3 >= 8, name="kidney_support_index_zinc_vitamin_C")
m.addConstr(1*x1 + 3*x3 >= 10, name="kidney_support_index_calcium_vitamin_C")
m.addConstr(1*x1 + 3*x2 + 3*x3 >= 15, name="kidney_support_index_all")
m.addConstr(2*x1**2 + 8*x2**2 >= 32, name="muscle_growth_index_calcium_zinc")
m.addConstr(11*x1**2 + 9*x3**2 >= 13, name="cardiovascular_support_index_calcium_vitamin_C")
m.addConstr(3*x2**2 + 3*x3**2 <= 19, name="kidney_support_index_zinc_vitamin_C_squared")
m.addConstr(1*x1 + 3*x2 <= 40, name="kidney_support_index_calcium_zinc")
m.addConstr(1*x1 + 3*x2 + 3*x3 <= 40, name="kidney_support_index_all_equal")
m.addConstr(2*x1**2 + 8*x2**2 <= 55, name="muscle_growth_index_calcium_zinc_squared")
m.addConstr(2*x1**2 + 5*x3**2 <= 79, name="muscle_growth_index_calcium_vitamin_C_squared")
m.addConstr(2*x1 + 8*x2 + 5*x3 <= 79, name="muscle_growth_index_all")
m.addConstr(11*x1 + 9*x3 <= 54, name="cardiovascular_support_index_calcium_vitamin_C_linear")
m.addConstr(11*x1 + 11*x2 + 9*x3 <= 54, name="cardiovascular_support_index_all")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of calcium: ", x1.varValue)
    print("Milligrams of zinc: ", x2.varValue)
    print("Milligrams of vitamin C: ", x3.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
