
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, ub=gp.GRB.INFINITY, name=["x0", "x1", "x2", "x3", "x4"])


# Set objective function
m.setObjective(2*x[0] + 2*x[1] + 5*x[2] + 7*x[3] + 3*x[4], gp.GRB.MAXIMIZE)

# Add constraints

tastiness = [14.54, 3.48, 15.72, 14.25, 6.87]
umami = [6.9, 9.36, 14.1, 10.96, 10.25]

m.addConstr(tastiness[0]*x[0] + tastiness[2]*x[2] >= 26)
m.addConstr(tastiness[3]*x[3] + tastiness[4]*x[4] >= 38)
m.addConstr(tastiness[1]*x[1] + tastiness[3]*x[3] >= 45)
m.addConstr(tastiness[1]*x[1] + tastiness[4]*x[4] >= 16)
m.addConstr(tastiness[0]*x[0] + tastiness[4]*x[4] >= 33)
m.addConstr(tastiness[1]*x[1] + tastiness[2]*x[2] >= 33)
m.addConstr(tastiness[2]*x[2] + tastiness[3]*x[3] >= 44)
m.addConstr(tastiness[0]*x[0] + tastiness[1]*x[1] + tastiness[2]*x[2] >= 38)
m.addConstr(tastiness[1]*x[1] + tastiness[2]*x[2] + tastiness[3]*x[3] >= 38)
m.addConstr(tastiness[0]*x[0] + tastiness[1]*x[1] + tastiness[2]*x[2] >= 44)
m.addConstr(tastiness[1]*x[1] + tastiness[2]*x[2] + tastiness[3]*x[3] >= 44)


m.addConstr(umami[1]*x[1] + umami[4]*x[4] >= 66)
m.addConstr(umami[0]*x[0] + umami[1]*x[1] >= 62)
m.addConstr(umami[1]*x[1] + umami[2]*x[2] >= 66)
m.addConstr(umami[2]*x[2] + umami[3]*x[3] >= 45)
m.addConstr(umami[0]*x[0] + umami[3]*x[3] >= 41)
m.addConstr(umami[0]*x[0] + umami[4]*x[4] >= 33)
m.addConstr(umami[0]*x[0] + umami[1]*x[1] + umami[3]*x[3] >= 49)
m.addConstr(umami[0]*x[0] + umami[2]*x[2] + umami[3]*x[3] >= 49)
m.addConstr(umami[2]*x[2] + umami[3]*x[3] + umami[4]*x[4] >= 49)
m.addConstr(umami[1]*x[1] + umami[3]*x[3] + umami[4]*x[4] >= 49)
m.addConstr(umami[0]*x[0] + umami[1]*x[1] + umami[4]*x[4] >= 49)
m.addConstr(umami[0]*x[0] + umami[2]*x[2] + umami[4]*x[4] >= 49)
m.addConstr(umami[0]*x[0] + umami[1]*x[1] + umami[3]*x[3] >= 59)
m.addConstr(umami[0]*x[0] + umami[2]*x[2] + umami[3]*x[3] >= 59)
m.addConstr(umami[2]*x[2] + umami[3]*x[3] + umami[4]*x[4] >= 59)
m.addConstr(umami[1]*x[1] + umami[3]*x[3] + umami[4]*x[4] >= 59)
m.addConstr(umami[0]*x[0] + umami[1]*x[1] + umami[4]*x[4] >= 59)
m.addConstr(umami[0]*x[0] + umami[2]*x[2] + umami[4]*x[4] >= 59)



m.addConstr(tastiness[2]*x[2] + tastiness[3]*x[3] <= 254)
m.addConstr(tastiness[1]*x[1] + tastiness[2]*x[2] <= 82)
m.addConstr(tastiness[2]*x[2] + tastiness[4]*x[4] <= 203)
m.addConstr(tastiness[0]*x[0] + tastiness[1]*x[1] <= 124)
m.addConstr(tastiness[3]*x[3] + tastiness[4]*x[4] <= 211)
m.addConstr(tastiness[0]*x[0] + tastiness[1]*x[1] + tastiness[4]*x[4] <= 92)
m.addConstr(sum([tastiness[i]*x[i] for i in range(5)]) <= 92)

m.addConstr(umami[1]*x[1] + umami[2]*x[2] <= 265)
m.addConstr(umami[2]*x[2] + umami[4]*x[4] <= 150)
m.addConstr(umami[2]*x[2] + umami[3]*x[3] <= 318)
m.addConstr(umami[1]*x[1] + umami[4]*x[4] <= 211)
m.addConstr(umami[0]*x[0] + umami[2]*x[2] <= 252)
m.addConstr(umami[1]*x[1] + umami[3]*x[3] <= 81)
m.addConstr(umami[0]*x[0] + umami[1]*x[1] <= 231)
m.addConstr(umami[0]*x[0] + umami[4]*x[4] <= 311)
m.addConstr(umami[0]*x[0] + umami[2]*x[2] + umami[4]*x[4] <= 167)
m.addConstr(umami[1]*x[1] + umami[2]*x[2] + umami[4]*x[4] <= 115)
m.addConstr(umami[1]*x[1] + umami[2]*x[2] + umami[3]*x[3] <= 210)
m.addConstr(umami[0]*x[0] + umami[1]*x[1] + umami[3]*x[3] <= 361)
m.addConstr(sum([umami[i]*x[i] for i in range(5)]) <= 361)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

