
import gurobipy as gp

# Create a new model
model = gp.Model("resource_allocation")

# Create variables
cafeteria_chairs = model.addVar(vtype=gp.GRB.INTEGER, name="cafeteria_chairs")
black_pens = model.addVar(vtype=gp.GRB.INTEGER, name="black_pens")
usb_flash_drives = model.addVar(vtype=gp.GRB.INTEGER, name="usb_flash_drives")


# Set objective function
model.setObjective(7 * cafeteria_chairs + 8 * black_pens + 4 * usb_flash_drives, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(9 * cafeteria_chairs + 12 * black_pens <= 51, "c1")
model.addConstr(9 * cafeteria_chairs + 12 * black_pens + 8 * usb_flash_drives <= 51, "c2")
model.addConstr(1 * cafeteria_chairs + 1 * usb_flash_drives <= 35, "c3")
model.addConstr(1 * black_pens + 1 * usb_flash_drives <= 67, "c4")
model.addConstr(1 * cafeteria_chairs + 1 * black_pens + 1 * usb_flash_drives <= 67, "c5")



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cafeteria Chairs: {cafeteria_chairs.x}")
    print(f"Black Pens: {black_pens.x}")
    print(f"USB Flash Drives: {usb_flash_drives.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

