
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="cafeteria_chairs", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="black_pens", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="usb_flash_drives", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7*x0 + 8*x1 + 4*x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(9*x0 + 12*x1 <= 51, name="sustainability_score_chairs_pens")
m.addConstr(9*x0 + 12*x1 + 8*x2 <= 51, name="sustainability_score_all")
m.addConstr(x0 + x2 <= 35, name="cost_chairs_usb")
m.addConstr(x1 + x2 <= 67, name="cost_pens_usb")
m.addConstr(x0 + x1 + x2 <= 67, name="total_cost")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Cafeteria Chairs: ", x0.varValue)
    print("Black Pens: ", x1.varValue)
    print("USB Flash Drives: ", x2.varValue)
else:
    print("The model is infeasible")
