
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
variables = {
    'hours worked by Ringo': m.addVar(lb=0, name='x0'),
    'hours worked by Jean': m.addVar(lb=0, name='x1'),
    'hours worked by Hank': m.addVar(lb=0, name='x2'),
    'hours worked by George': m.addVar(lb=0, name='x3'),
    'hours worked by Laura': m.addVar(lb=0, name='x4'),
    'hours worked by Bobby': m.addVar(lb=0, name='x5')
}


# Set objective function
m.setObjective(2*variables['hours worked by Ringo'] + 4*variables['hours worked by Jean'] + 1*variables['hours worked by Hank'] + 2*variables['hours worked by George'] + 8*variables['hours worked by Laura'] + 6*variables['hours worked by Bobby'], gp.GRB.MINIMIZE)

# Set constraints
resources = {
    'r0': {'description': 'computer competence rating', 'upper_bound': 374, 'x0': 15.73, 'x1': 4.24, 'x2': 13.87, 'x3': 3.38, 'x4': 12.37, 'x5': 13.37},
    'r1': {'description': 'productivity rating', 'upper_bound': 462, 'x0': 5.0, 'x1': 7.79, 'x2': 16.3, 'x3': 9.14, 'x4': 3.59, 'x5': 16.66},
    'r2': {'description': 'dollar cost per hour', 'upper_bound': 445, 'x0': 10.69, 'x1': 1.53, 'x2': 10.54, 'x3': 7.47, 'x4': 6.51, 'x5': 17.9},
    'r3': {'description': 'paperwork competence rating', 'upper_bound': 367, 'x0': 2.46, 'x1': 16.0, 'x2': 15.12, 'x3': 6.52, 'x4': 4.02, 'x5': 1.59}
}

# Add constraints from the input description.  These are manually entered based on the prompt.
m.addConstr(15.73 * variables['hours worked by Ringo'] + 4.24 * variables['hours worked by Jean'] >= 40)
m.addConstr(15.73 * variables['hours worked by Ringo'] + 12.37 * variables['hours worked by Laura'] >= 28)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

