
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Ringo
x1 = m.addVar(name="x1", lb=0)  # hours worked by Jean
x2 = m.addVar(name="x2", lb=0)  # hours worked by Hank
x3 = m.addVar(name="x3", lb=0)  # hours worked by George
x4 = m.addVar(name="x4", lb=0)  # hours worked by Laura
x5 = m.addVar(name="x5", lb=0)  # hours worked by Bobby

# Define the objective function
m.setObjective(2 * x0 + 4 * x1 + x2 + 2 * x3 + 8 * x4 + 6 * x5, gurobi.GRB.MINIMIZE)

# Add constraints
# Computer competence rating constraints
m.addConstr(15.73 * x0 + 4.24 * x1 >= 40)
m.addConstr(15.73 * x0 + 12.37 * x4 >= 28)
m.addConstr(4.24 * x1 + 12.37 * x4 >= 21)
m.addConstr(13.87 * x2 + 13.37 * x5 >= 58)
m.addConstr(3.38 * x3 + 13.37 * x5 >= 46)
m.addConstr(13.87 * x2 + 3.38 * x3 >= 30)
m.addConstr(15.73 * x0 + 3.38 * x3 >= 29)
m.addConstr(4.24 * x1 + 3.38 * x3 >= 61)

# ... add all other constraints similarly

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x0: ", x0.x)
    print("x1: ", x1.x)
    print("x2: ", x2.x)
    print("x3: ", x3.x)
    print("x4: ", x4.x)
    print("x5: ", x5.x)
else:
    print("No solution found")
