
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(name="protein_bars")
x1 = m.addVar(name="slices_of_pizza")
x2 = m.addVar(name="black_beans")
x3 = m.addVar(name="corn_cobs")


# Set objective function
m.setObjective(9*x0 + 4*x1 + 2*x2 + x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.77*x0 + 1.24*x2 >= 83)
m.addConstr(0.77*x0 + 3.87*x3 >= 72)
m.addConstr(2.27*x0 + 1.67*x1 >= 17)
m.addConstr(1.67*x1 + 2.46*x2 >= 15)
m.addConstr(3.21*x0 + 2.47*x1 >= 65)
m.addConstr(2.47*x1 + 2.12*x2 >= 54)
m.addConstr(3.21*x0 + 3.44*x3 >= 66)
m.addConstr(3.21*x0 + 2.12*x2 >= 35)
m.addConstr(2.12*x2 + 3.44*x3 >= 43)
m.addConstr(3.21*x0 + 2.12*x2 + 3.44*x3 >= 64)
m.addConstr(0.91*x0 + 1.77*x3 >= 55)
m.addConstr(0.91*x0 + 0.06*x2 >= 69)
m.addConstr(0.91*x0 + 1.22*x1 >= 54)
m.addConstr(1.22*x1 + 1.77*x3 >= 61)
m.addConstr(1.22*x1 + 0.06*x2 >= 46)
m.addConstr(1.24*x2 + 3.87*x3 <= 213)
m.addConstr(0.77*x0 + 3.87*x3 <= 159)
m.addConstr(0.77*x0 + 1.24*x2 <= 198)
m.addConstr(1.91*x1 + 3.87*x3 <= 300)
m.addConstr(0.77*x0 + 1.91*x1 <= 240)
m.addConstr(0.77*x0 + 1.91*x1 + 1.24*x2 + 3.87*x3 <= 240)
m.addConstr(2.27*x0 + 2.47*x3 <= 28)
m.addConstr(1.67*x1 + 2.46*x2 <= 36)
m.addConstr(2.46*x2 + 2.47*x3 <= 26)
m.addConstr(1.67*x1 + 2.47*x3 <= 65)
m.addConstr(2.27*x0 + 1.67*x1 + 2.46*x2 + 2.47*x3 <= 65)
m.addConstr(2.12*x2 + 3.44*x3 <= 211)
m.addConstr(3.21*x0 + 2.12*x2 <= 284)
m.addConstr(3.21*x0 + 2.47*x1 <= 153)
m.addConstr(2.47*x1 + 2.12*x2 <= 139)
m.addConstr(3.21*x0 + 2.47*x1 + 3.44*x3 <= 135)
m.addConstr(3.21*x0 + 2.47*x1 + 2.12*x2 <= 175)
m.addConstr(3.21*x0 + 2.47*x1 + 2.12*x2 + 3.44*x3 <= 175)
m.addConstr(1.22*x1 + 1.77*x3 <= 304)
m.addConstr(0.06*x2 + 1.77*x3 <= 101)
m.addConstr(0.91*x0 + 1.77*x3 <= 280)
m.addConstr(1.22*x1 + 0.06*x2 + 1.77*x3 <= 303)
m.addConstr(0.91*x0 + 0.06*x2 + 1.77*x3 <= 147)
m.addConstr(0.91*x0 + 1.22*x1 + 0.06*x2 + 1.77*x3 <= 147)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

