
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    calcium = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="calcium")
    potassium = m.addVar(lb=0, vtype=GRB.INTEGER, name="potassium")


    # Set objective function
    m.setObjective(7 * calcium + 5 * potassium, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8 * calcium + 4 * potassium >= 18, "kidney_support_min")
    m.addConstr(1 * calcium + 7 * potassium >= 31, "energy_stability_min")
    m.addConstr(4 * calcium + 4 * potassium >= 36, "digestive_support_min")
    m.addConstr(12 * calcium + 7 * potassium >= 26, "cognitive_performance_min")
    m.addConstr(1 * calcium - 6 * potassium >= 0, "calcium_potassium_ratio")

    m.addConstr(8 * calcium + 4 * potassium <= 97, "kidney_support_max")
    m.addConstr(1 * calcium + 7 * potassium <= 120, "energy_stability_max")
    m.addConstr(4 * calcium + 4 * potassium <= 62, "digestive_support_max")
    m.addConstr(12 * calcium + 7 * potassium <= 102, "cognitive_performance_max")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('calcium: %g' % calcium.x)
        print('potassium: %g' % potassium.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
