
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="milligrams_of_calcium", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_potassium", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7 * x1 + 5 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * x1 + 4 * x2 >= 18, name="kidney_support_index")
m.addConstr(x1 + 7 * x2 >= 31, name="energy_stability_index")
m.addConstr(4 * x1 + 4 * x2 >= 36, name="digestive_support_index")
m.addConstr(12 * x1 + 7 * x2 >= 26, name="cognitive_performance_index")
m.addConstr(x1 - 6 * x2 >= 0, name="calcium_potassium_ratio")
m.addConstr(8 * x1 + 4 * x2 <= 97, name="kidney_support_index_upper_bound")
m.addConstr(x1 + 7 * x2 <= 120, name="energy_stability_index_upper_bound")
m.addConstr(4 * x1 + 4 * x2 <= 62, name="digestive_support_index_upper_bound")
m.addConstr(12 * x1 + 7 * x2 <= 102, name="cognitive_performance_index_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of calcium: {x1.varValue}")
    print(f"Milligrams of potassium: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
