
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B5
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of zinc
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B7
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin B4
    x4 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x4") # milligrams of calcium


    # Set objective function
    m.setObjective(5.81 * x0 + 4.93 * x1 + 5.73 * x2 + 8.21 * x3 + 8.07 * x4, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5 * x0 + 20 * x1 + 31 * x2 >= 69, "c0")
    m.addConstr(5 * x0 + 20 * x1 + 14 * x3 >= 69, "c1")
    m.addConstr(5 * x0 + 20 * x1 + 31 * x2 >= 80, "c2")
    m.addConstr(5 * x0 + 20 * x1 + 14 * x3 >= 80, "c3")
    m.addConstr(5 * x0 + 31 * x4 <= 486, "c4")
    m.addConstr(20 * x1 + 31 * x2 <= 213, "c5")
    m.addConstr(5 * x0 + 20 * x1 + 31 * x2 + 14 * x3 + 31 * x4 <= 213, "c6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
